using System;
using System.Data;
using System.Data.SqlTypes;
using System.Data.SqlClient;
using MethodBase = System.Reflection.MethodBase;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>08/23/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// PatientRecordReport data access layer class.
	///</summary>

	#endregion
	
	public class PatientRecordReport
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>08/17/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5562"> 
		///		<ExpectedInput>Valid patient and division code</ExpectedInput>
		///		<ExpectedOutput>Count of records in patient record report (>0)</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5563"> 
		///		<ExpectedInput>Invalid patient and division code</ExpectedInput>
		///		<ExpectedOutput>Count of records in patient record report (=0)</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetPatientRecordReportCount
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <param name="divisionCode"></param>
		/// <param name="includeDemographics"></param>
		/// <param name="includeSpecimens"></param>
		/// <param name="includeTests"></param>
		/// <param name="includeAssignments"></param>
		/// <param name="includeTransfusions"></param>
		/// <param name="includeReactions"></param>
		/// <param name="includeRequirements"></param>
		/// <param name="includeInstructions"></param>
		/// <param name="includeExceptions"></param>
		/// <returns></returns>
		public static int GetPatientRecordReportCount(Guid patientGuid, string divisionCode, bool includeDemographics,
			bool includeSpecimens, bool includeTests, bool includeAssignments, bool includeTransfusions, bool includeReactions, 
			bool includeRequirements, bool includeInstructions, bool includeExceptions)
		{
			int count = 0;
			//
			SqlParameter [] prms = 
				{
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.patientguid, System.Data.SqlDbType.UniqueIdentifier),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.divisioncode, System.Data.SqlDbType.Char),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includedemographics, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includespecimens, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includepatienttests, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includeunitassignments, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includetransfusions, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includetransfusionreactions, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includetransfusionrequirements, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includespecialinstructions, System.Data.SqlDbType.Bit),
					new SqlParameter(STOREDPROC.GetPatientRecordReportCount.includeexceptions, System.Data.SqlDbType.Bit)
				};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;
			prms[2].Value = includeDemographics;
			prms[3].Value = includeSpecimens;
			prms[4].Value = includeTests;
			prms[5].Value = includeAssignments;
			prms[6].Value = includeTransfusions;
			prms[7].Value = includeReactions;
			prms[8].Value = includeRequirements;
			prms[9].Value = includeInstructions;
			prms[10].Value = includeExceptions;
			//
			DataSet ds = StoredProcedure.GetData(STOREDPROC.GetPatientRecordReportCount.StoredProcName, prms);
			foreach(DataTable dt in ds.Tables)
			{
				foreach(DataRow dr in dt.Rows)
				{
					count += (int)dr["Total"];
				}
			}
			//
			return count;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>08/05/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5564"> 
		///		<ExpectedInput>Valid patient and division code</ExpectedInput>
		///		<ExpectedOutput>Populated patient record report data set</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5565"> 
		///		<ExpectedInput>Invalid patient and division code</ExpectedInput>
		///		<ExpectedOutput>Empty patient record report data set</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetPatientRecordReportCount
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <param name="divisionCode"></param>
		/// <param name="includeDemographics"></param>
		/// <param name="includeSpecimens"></param>
		/// <param name="includeTests"></param>
		/// <param name="includeAssignments"></param>
		/// <param name="includeTransfusions"></param>
		/// <param name="includeReactions"></param>
		/// <param name="includeRequirements"></param>
		/// <param name="includeInstructions"></param>
		/// <param name="includeExceptions"></param>
		/// <returns></returns>
		public static DataSet GetPatientRecordReport(Guid patientGuid, string divisionCode, bool includeDemographics,
			bool includeSpecimens, bool includeTests, bool includeAssignments, bool includeTransfusions, bool includeReactions, 
			bool includeRequirements, bool includeInstructions, bool includeExceptions)
		{
			DataSet ds = new DataSet();
			//
			if (includeDemographics)
			{
				DataSet dsDemographics = GetPatientRecordReportDemographics(patientGuid, divisionCode);
				ds.Tables.Add(dsDemographics.Tables[0].Copy());
				ds.Tables.Add(dsDemographics.Tables[1].Copy());
			}
			//
			if (includeSpecimens)
			{
				ds.Tables.Add(GetPatientRecordReportPatientSpecimens(patientGuid, divisionCode).Copy());
			}
			//
			if (includeAssignments)
			{
				ds.Tables.Add(GetPatientRecordReportUnitAssignments(patientGuid, divisionCode).Copy());
			}
			//
			if (includeTests)
			{
				ds.Tables.Add(GetPatientRecordReportTestResults(patientGuid, divisionCode).Copy());
			}
			//
			if (includeTransfusions)
			{
				ds.Tables.Add(GetPatientRecordReportTransfusions(patientGuid, divisionCode).Copy());
			}
			//
			if (includeReactions)
			{
				DataSet dsTrw = GetPatientRecordReportTransfusionReactionWorkup(patientGuid, divisionCode);
				ds.Tables.Add(dsTrw.Tables[Common.VbecsTables.PatientTransfusionReaction.TableName].Copy());
				ds.Tables.Add(dsTrw.Tables[Common.VbecsTables.PatientTransfusionReactionSymptom.TableName].Copy());
				ds.Tables.Add(dsTrw.Tables[Common.VbecsTables.TransfusionReaction.TableName].Copy());
				ds.Tables.Add(dsTrw.Tables["TrwSerologicTests"].Copy());
			}
			//
			if (includeRequirements)
			{
				ds.Tables.Add(GetPatientRecordReportTransfusionRequirements(patientGuid, divisionCode).Copy());
			}
			//
			if (includeInstructions)
			{
				ds.Tables.Add(GetPatientRecordReportSpecialInstructions(patientGuid, divisionCode).Copy());
			}
			//
			if (includeExceptions)
			{
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportAboIncompatibleTransfusion(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportPatientAboRH(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportPatientAboRHDiscrepancy(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportPatientAntigenDiscrepancy(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportPatientTest(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportPatientTestInactivated(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportQCNotPerformed(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportReflexTest(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportSpecimen(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportUnitSelection(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportTrwSpecimen(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportTransfusionReactionWorkup(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportCautionTagBTRF(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportReturnIssuedUnit(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportTransfusion(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportUnitIssue(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportEmergencyIssueOrder(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportEmergencyIssueUnitTest(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportPatientRestriction(divisionCode, patientGuid).Tables[0].Copy());
				ds.Tables.Add(DAL.ExceptionReport.GetExceptionReportQC(divisionCode, patientGuid).Tables[0].Copy());
			}
			//
			return ds;
		}

		/// <summary>
		/// Get Patient Record Report Patient Specimens Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>Patient specimens data table</returns>
		private static DataTable GetPatientRecordReportPatientSpecimens(Guid patientGuid, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetPatientSpecimenRecordHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetPatientSpecimenRecordHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetPatientSpecimenRecordHistoryForPatient.StoredProcName, prms).Tables[0];
			dt.TableName = Common.VbecsTables.PatientSpecimen.TableName;
			return dt;
		}

		/// <summary>
		/// Get Patient Record Report Unit Assignments Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>Ordered unit data table</returns>
		private static DataTable GetPatientRecordReportUnitAssignments(Guid patientGuid, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetOrderedUnitRecordHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetOrderedUnitRecordHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetOrderedUnitRecordHistoryForPatient.StoredProcName, prms).Tables[0];
			dt.TableName = Common.VbecsTables.OrderedUnit.TableName;
			return dt;
		}

		/// <summary>
		/// Get Patient Record Report Patient Transfusion Requirements Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>Patient transfusion requirements data table</returns>
		private static DataTable GetPatientRecordReportTransfusionRequirements(Guid patientGuid, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetPatientTransfusionRequirementRecordHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetPatientTransfusionRequirementRecordHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetPatientTransfusionRequirementRecordHistoryForPatient.StoredProcName, prms).Tables[0];
			dt.TableName = Common.VbecsTables.PatientTransfusionRequirement.TableName;
			return dt;
		}

		/// <summary>
		/// Get Patient Record Report Patient Special Instructions Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>Patient special instructions data table</returns>
		private static DataTable GetPatientRecordReportSpecialInstructions(Guid patientGuid, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetPatientSpecialInstructionRecordHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetPatientSpecialInstructionRecordHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetPatientSpecialInstructionRecordHistoryForPatient.StoredProcName, prms).Tables[0];
			dt.TableName = Common.VbecsTables.PatientSpecialInstruction.TableName;
			return dt;
		}

		/// <summary>
		/// Get Patient Record Report Patient Demographics Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>Patient data table and Patient ABO/Rh data table</returns>
		private static DataSet GetPatientRecordReportDemographics(Guid patientGuid, string divisionCode)
		{
            SqlParameter[] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetPatientDemographicHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetPatientDemographicHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
            prms[0].Value = patientGuid;
            prms[1].Value = divisionCode;

            DataSet ds = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetPatientDemographicHistoryForPatient.StoredProcName, prms);
            DataTable dt = ds.Tables[0];
            dt.TableName = Common.VbecsTables.Patient.TableName;
            //CR3315, CR 3465


            DataTable dtCopy = dt.Clone();


            bool RowModified = false;
            int nCount = dt.Rows.Count;

            //Always grab the first row
            if (dt.Rows.Count > 0)
            {
                DataRow dr = dtCopy.NewRow();
                dr.ItemArray = dt.Rows[0].ItemArray;
                dtCopy.Rows.Add(dr);
            }
            
            //loop thru all the rows
            for (int i = 0; i < nCount - 1; i++)
		    {
		        //loop thru all col and evaulate value for second row and on
		        foreach (DataColumn dtCol in dt.Columns)
		        {
		            if (dtCol.ColumnName != TABLE.Patient.LastUpdateDate &&
		                dtCol.ColumnName != TABLE.Patient.LastUpdateUser &&
		                dtCol.ColumnName != TABLE.Patient.PatientGuid)
		            {
		                if (dt.Rows[i][dtCol].Equals(dt.Rows[i + 1][dtCol]))
		                {
		                    continue;
		                }
		                else
		                {
		                    RowModified = true;
		                    break;
		                }
		            }
		        }
		        if (RowModified)
                {
                    DataRow dr = dtCopy.NewRow();
                    dr.ItemArray = dt.Rows[i + 1].ItemArray;
                    dtCopy.Rows.Add(dr);
                }
            }
            System.Data.DataSet dsNew = new DataSet();
            dtCopy.TableName = Common.VbecsTables.Patient.TableName;
            dsNew.Tables.Add(dtCopy);

            //END CR 3315, CR 3465
            DataTable dt2 = ds.Tables[1].Copy();
            dt2.TableName = "PatientAboRH";
            dsNew.Tables.Add(dt2);

            return dsNew;
		}

		/// <summary>
		/// Get Patient Record Report Patient Transfusions Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>Patient transfusion data table</returns>
		private static DataTable GetPatientRecordReportTransfusions(Guid patientGuid, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetPatientTransfusionRecordHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetPatientTransfusionRecordHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetPatientTransfusionRecordHistoryForPatient.StoredProcName, prms).Tables[0];
			dt.TableName = Common.VbecsTables.PatientTransfusion.TableName;
			return dt;
		}

		/// <summary>
		/// Get Patient Record Report Patient Testing Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>Specimen test data table</returns>
		private static DataTable GetPatientRecordReportTestResults(Guid patientGuid, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetSpecimenTestRecordHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetSpecimenTestRecordHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetSpecimenTestRecordHistoryForPatient.StoredProcName, prms).Tables[0];
			dt.TableName = Common.VbecsTables.SpecimenTest.TableName;
			return dt;
		}

		/// <summary>
		/// Get Patient Record Report Patient Transfusion Reaction Section
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <param name="divisionCode">Division Code</param>
		/// <returns>TRW data set</returns>
		private static DataSet GetPatientRecordReportTransfusionReactionWorkup(Guid patientGuid, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(Common.VbecsStoredProcs.GetPatientTransfusionReactionRecordHistoryForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(Common.VbecsStoredProcs.GetPatientTransfusionReactionRecordHistoryForPatient.divisioncode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = divisionCode;

			DataSet ds = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetPatientTransfusionReactionRecordHistoryForPatient.StoredProcName, prms);
			ds.Tables[0].TableName = Common.VbecsTables.PatientTransfusionReaction.TableName;
			ds.Tables[1].TableName = Common.VbecsTables.PatientTransfusionReactionSymptom.TableName;
			ds.Tables[2].TableName = Common.VbecsTables.TransfusionReaction.TableName;
			ds.Tables[3].TableName = "TrwSerologicTests";
			//
			return ds;
		}
	}
}
